<?php
    /**
    *
    * copyright (c) 2013-2018 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "../costanti.php";
    include "../util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GeneratoreEmail.php";
    include "../classi/GeneratoreUrl.php";

    session_start();
    //controllo di sicurezza, verifica che l'utente sta inviando i campi dalla pagina index.php
    if(!isset($_POST["tokenSicurezza"]) || !isset($_SESSION["tokenSicurezza"])) {
        header("Location: index.php?status=444");
    }
    else if ($_POST["tokenSicurezza"]!= $_SESSION["tokenSicurezza"]) {
        unset($_SESSION["tokenSicurezza"]);
        header("Location: index.php?status=444");
    }
    else {
        unset($_SESSION["tokenSicurezza"]);

        //i dati del database sono definiti nel file costanti.php
        $geecomDb = new DbManager($costantiDatabase);
        $impostazioni = recuperaImpostazioni($geecomDb);
        //dati admin
        $email = $geecomDb->escapeString($_POST['email']);

        $queryLogin = "SELECT * FROM geec_utenti WHERE email='$email'";
        $result = $geecomDb->eseguiQueryLettura($queryLogin);

        $impostazioni = recuperaImpostazioni($geecomDb);
        $pagina       = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $impostazioni["paginaRecuperoPassword"]);
        $linkPagina   = GeneratoreUrl::creaUrlContenuto($pagina, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
        
        if($result->num_rows>0) {
            $admin = $result->fetch_array(MYSQLI_ASSOC);

            //genero la password casuale
            $nuovaPassword = "";
            for($i=0;$i<7;$i++) {
                $num = rand(0,51);
                $a_z = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                $nuovaPassword = $nuovaPassword.$a_z[$num];
            }

            $nuovaPasswordSha512 = hash("sha512",$nuovaPassword);
            $queryAggiornamentoPassword = "UPDATE geec_utenti SET password='$nuovaPasswordSha512' WHERE id = {$admin["id"]}";
            $geecomDb->eseguiQueryLettura($queryAggiornamentoPassword);

            //se ha creato l'utente invia una mail con i dati dell'account
            $generatoreEmail = new GeneratoreEmail($impostazioni["nomeMittente"], $impostazioni["emailMittente"]);

            $oggetto = "La tua nuova password";
            $messaggio = "Ciao {$admin["nome"]},<br> ecco la tua nuova password:$nuovaPassword<br> è consigliabile cambiare questa
            password al primo login";

            $generatoreEmail->invia($email, $oggetto, $messaggio);

            header("Location: $linkPagina&status=100");
        }
        else {
            header("Location: $linkPagina&status=400");
        }
    }